'use strict';

function BCPEmployeeModalCtrl($scope){
    var elementId = "#modal-employees";

    $scope.currentDepartment = {};
    $scope.checkedAll = false;
    $scope.search = {};

    $scope.replacePolishLetters = function(word) {
        if(!word)
            word = '';

        word = word.replace(new RegExp('ą', 'g'), 'a');
        word = word.replace(new RegExp('ć', 'g'), 'c');
        word = word.replace(new RegExp('ę', 'g'), 'e');
        word = word.replace(new RegExp('ł', 'g'), 'l');
        word = word.replace(new RegExp('ń', 'g'), 'n');
        word = word.replace(new RegExp('ó', 'g'), 'o');
        word = word.replace(new RegExp('ś', 'g'), 's');
        word = word.replace(new RegExp('ż', 'g'), 'z');
        word = word.replace(new RegExp('ź', 'g'), 'z');

        word = word.replace(new RegExp('Ą', 'g'), 'A');
        word = word.replace(new RegExp('Ć', 'g'), 'C');
        word = word.replace(new RegExp('Ę', 'g'), 'E');
        word = word.replace(new RegExp('Ł', 'g'), 'L');
        word = word.replace(new RegExp('Ń', 'g'), 'N');
        word = word.replace(new RegExp('Ó', 'g'), 'O');
        word = word.replace(new RegExp('Ś', 'g'), 'S');
        word = word.replace(new RegExp('Ż', 'g'), 'Z');
        word = word.replace(new RegExp('Ź', 'g'), 'Z');

        return word;
    }

    $scope.$on('Employees:openWindow', function(event, department){
        $scope.currentDepartment = department;
        $scope.openModal();
    });

    $scope.openModal = function(){
        angular.element(elementId).modal('show');
        setTimeout(function(){
            $(".nano").nanoScroller({alwaysVisible: true});
        }, 300);
    }

    $scope.closeModal = function(){
        angular.element(elementId).modal('hide');
    }

    $scope.checkAll = function(){
        $scope.checkedAll = ($scope.isAllEmployeesChecked()) ? false : true;
        $scope.currentDepartment.employees.forEach(function(Employee){
            if(($scope.checkedAll && !Employee.isChecked()) || (!$scope.checkedAll && Employee.isChecked()))
            {
                Employee.check();
            }
        });
    }


    $scope.isAllEmployeesChecked = function(){
        if(typeof $scope.currentDepartment.employees != 'undefined')
        {
            var allChecked = true;
            for(var i = 0; i < $scope.currentDepartment.employees.length; i++)
            {
                if(!$scope.currentDepartment.employees[i].isChecked())
                {
                    allChecked = false;
                    break;
                }
            }
            return allChecked;
        }
        else
        {
            return false;
        }
    }

    $scope.filterEmployees = function(employee){
        var valid = true;

        if(typeof $scope.search.salaryMin != 'undefined' && $scope.search.salaryMin != ''){
            valid = (employee.salary >= $scope.search.salaryMin);
            if(!valid) {return valid;}
        }
        if(typeof $scope.search.salaryMax != 'undefined' && $scope.search.salaryMax != '')
        {
            valid = (employee.salary <= $scope.search.salaryMax);
            if(!valid) {return valid;}
        }
        if(typeof $scope.search.seniorityMin != 'undefined' && $scope.search.seniorityMin != ''){
            valid = ((employee.seniority) >= $scope.search.seniorityMin);
            if(!valid) {return valid;}
        }
        if(typeof $scope.search.seniorityMax != 'undefined' && $scope.search.seniorityMax != ''){
            valid = ((employee.seniority) <= $scope.search.seniorityMax);
            if(!valid) {return valid;}
        }
        if(typeof $scope.search.education != 'undefined' && $scope.search.education != ''){
            valid = (employee.education == $scope.search.education);
            if(!valid) {return valid;}
        }
        if(typeof $scope.search.studies != 'undefined' && $scope.search.studies != ''){
            valid = (employee.studies == $scope.search.studies);
            if(!valid) {return valid;}
        }
        if(typeof $scope.search.driver != 'undefined' && $scope.search.driver != '')
        {
            var cats = angular.copy($scope.search.driver.toLowerCase());
            cats = cats.replace(/[^a-z]/g, '').split('');

            for(var i = 0; i < cats.length; i++)
            {
                if(employee.driver.toLowerCase().indexOf(cats[i]) === -1)
                {
                    valid = false;
                    break;
                }
            };

            if(!valid) {return valid;}
        }

        return valid;
    }

    $scope.save = function(){

        $scope.closeModal();
    }


    $scope.dismissAllChecked = function() {
        for(var i = $scope.currentDepartment.employees.length-1;i>=0;i--){
            if($scope.currentDepartment.employees[i].isChecked())
            {
                $scope.currentDepartment.fireEmployee($scope.currentDepartment.employees[i]);
            }
        }

        $scope.closeModal();
    }

    $scope.isAnySelected = function(){
        var isSelected = false;
        if(typeof $scope.currentDepartment.employees != 'undefined')
        {
            for(var i = 0; i < $scope.currentDepartment.employees.length; i++)
            {
                if($scope.currentDepartment.employees[i].isChecked())
                {
                    isSelected = true;
                    break;
                }
            }
        }
        return isSelected;
    }
}

BCPEmployeeModalCtrl.$inject = ['$scope'];
